import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

/**
 * @author (Ihr Name) 
 * @version (eine Versionsnummer oder ein Datum)
 */
public class Benutzerschnittstelle extends JFrame
{
    private Steuerung steuerung;
    private Sudoku sudoku;

    private HashMap <JButton, Feld> hashMapButtonFeld;
    private HashMap <JButton, Integer> hashMapButtonBenutzereingabe;

    private static final Color FELD_VERAENDERBAR = Color.green;
    private static final Color FELD_NICHT_VERAENDERBAR = Color.black;

    private JButton beenden, pruefen, formation1;

    private JButton [] [] feld1;
    private HashSet<JButton> benutzereingabe;

    private JButton aktuellesFeld;

    public Benutzerschnittstelle(Steuerung pSteuerung, Sudoku pSudoku)
    {
        this.steuerung = pSteuerung;
        this.sudoku = pSudoku;
        erstelleBildschirm(); 
    }

    private void erstelleBildschirm()
    {
        this.setName("Game of Live");
        this.setSize(900, 700);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLayout(null);

        //Buttons
        beenden = new JButton("Beenden");
        beenden.setBounds(20, 50, 120, 20);
        add(beenden);
        beenden.addActionListener(listenerBeenden);

        formation1 = new JButton("Formation1");
        formation1.setBounds(20, 230, 120, 20);
        add(formation1);
        formation1.addActionListener(listenerButtonsFormation1);

        pruefen = new JButton("Pruefen");
        pruefen.setBounds(20, 90, 120, 20);
        add(pruefen);
        pruefen.addActionListener(listenerButtonsPruefen);

        eingabeFeldInitialisieren();
        this.setVisible(true);
    }

    private void felderAktualisieren()
    {
        int maximalY = sudoku.gibSeitenLaenge();
        int maximalX = sudoku.gibSeitenLaenge();

        int positionY = 0;
        int positionX = 0;  

        while (positionY < maximalY)
        {
            positionX = 0;
            while (positionX < maximalX)
            {
                JButton tmp = null;
                tmp = feld1 [positionY] [positionX];
                Feld felder = hashMapButtonFeld.get(tmp);

                if (felder.getZahl() == 0)
                {

                    tmp.setText("");
                }
                else if (felder.getZahl() >= 1 && felder.getZahl() <= 9)
                {
                    tmp.setText("" + felder.getZahl());
                }
                else
                {
                    System.out.println("Fehler buttonsRichtigeZahlenGeben(), else");
                }
                tmp.setBackground (Color. white);
                if (aktuellesFeld != null)
                {
                    aktuellesFeld.setBackground (Color.yellow);
                }
                positionX ++;
            }
            positionY ++;
        }
    }

    private void erzeugeDasSpielfeld()
    {
        feld1 = null;
        int maximalY = sudoku.gibSeitenLaenge();
        int maximalX = sudoku.gibSeitenLaenge();
        feld1 = new JButton [maximalY]  [maximalX];
        int positionY = 0;
        int positionX = 0;
        hashMapButtonFeld = new HashMap<JButton, Feld> ();
        int sudokuBlock3 = 10;

        while (positionY < maximalY)
        {
            positionX = 0;
            int sudokuBlock3RelativIntY = positionY / 3;
            while (positionX < maximalX)
            {
                JButton tmp = new JButton ("x=" + positionX+1 + "   y=" + positionY+1);
                feld1 [positionY] [positionX] =  tmp;

                int sudokuBlock3RelativIntX = positionX / 3;

                tmp.setBounds(250 + (sudokuBlock3 * sudokuBlock3RelativIntX) + ((positionX + 1) * 52), 20 + (sudokuBlock3 * sudokuBlock3RelativIntY) + ((positionY + 1) * 52), 50, 50);

                hashMapButtonFeld.put(tmp, sudoku.gibFeld(positionX, positionY));
                if (sudoku.veraenderbar(positionX, positionY) == true)
                {
                    tmp.setForeground(FELD_VERAENDERBAR);
                }
                else if (sudoku.veraenderbar(positionX, positionY) == false)
                {
                    tmp.setForeground(FELD_NICHT_VERAENDERBAR);
                }

                add(tmp);
                tmp.addActionListener(listenerButtonsSpielfeld);

                positionX ++;

            }
            positionY ++;

        }
    }

    public void eingabeFeldInitialisieren()
    {
        benutzereingabe = new HashSet<JButton> ();
        hashMapButtonBenutzereingabe = new HashMap <JButton, Integer> ();

        for (int i = 0; i < 5; i++)
        {
            int x = 60;
            int y = 60;
            JButton tmp = new JButton("" + i);
            benutzereingabe.add(tmp);

            tmp.setBounds(20 + x, 300 + y * i, 50, 50);
            add(tmp);
            tmp.addActionListener(listenerButtonsBenutzereingabe);
            hashMapButtonBenutzereingabe.put(tmp, new Integer(i));  
        }

        for (int i = 5; i < 10; i++)
        {
            int x = 60;
            int y = 60;
            JButton tmp = new JButton("" + i);
            benutzereingabe.add(tmp);

            tmp.setBounds(20 + x + 60, 300 + y * (i - 5), 50, 50);
            add(tmp);
            tmp.addActionListener(listenerButtonsBenutzereingabe);
            hashMapButtonBenutzereingabe.put(tmp, new Integer(i));  
        }
    }

    private final ActionListener listenerBeenden = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){

                System.exit(0);
            }
        };

    private final ActionListener listenerButtonsFormation1 = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                steuerung.formation1();
                erzeugeDasSpielfeld();

                felderAktualisieren();
            }
        };

    private final ActionListener listenerButtonsPruefen = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){

                if (sudoku.besitztFeld() == true)
                {

                    boolean tmp = steuerung.testeObSudokuKorrektIst();
                    if (tmp)
                    {
                        pruefen.setBackground (Color.green);
                    }
                    else
                    {
                        pruefen.setBackground (Color.red);
                    }
                }
            }
        };

    private final ActionListener listenerButtonsSpielfeld = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (sudoku.besitztFeld() == true)
                {
                    aktuellesFeld = (JButton) e.getSource();

                    felderAktualisieren();

                }
            }
        };

    private final ActionListener listenerButtonsBenutzereingabe = new ActionListener(){
            @Override public void actionPerformed(ActionEvent e){
                if (sudoku.besitztFeld() == true)
                {
                    JButton tmp = (JButton) e.getSource();
                    int wert = hashMapButtonBenutzereingabe.get(tmp).intValue();
                    hashMapButtonFeld.get(aktuellesFeld).setzeZahl(wert);
                    felderAktualisieren();
                }
            }
        };

}